
        // シーンのセットアップ
        const scene = new THREE.Scene();
        const camera = new THREE.PerspectiveCamera(75, window.innerWidth / window.innerHeight, 0.1, 1000);
        const renderer = new THREE.WebGLRenderer({ antialias: true });
        renderer.setSize(window.innerWidth, window.innerHeight);
        renderer.setClearColor(0xffffff);
        document.body.appendChild(renderer.domElement);

        // カメラの初期位置
        camera.position.set(0, 5, 0);

        // ライト
        const ambientLight = new THREE.AmbientLight(0xffffff, 0.5);
        scene.add(ambientLight);
        const directionalLight = new THREE.DirectionalLight(0xffffff, 0.5);
        directionalLight.position.set(5, 10, 7.5);
        scene.add(directionalLight);

        // 立方体の生成
        const cubeGeometry = new THREE.BoxGeometry(1, 1, 1);
        const cubeMaterial = new THREE.MeshPhongMaterial({ 
            color: 0x111111,
            specular: 0x555555,
            shininess: 30
        });

        const cubes = [];
        for (let i = 0; i < 20; i++) {
            const cube = new THREE.Mesh(cubeGeometry, cubeMaterial);
            cube.position.set(
                Math.random() * 20 - 10,
                Math.random() * 10,
                Math.random() * 20 - 10
            );
            scene.add(cube);
            cubes.push(cube);
        }

        // 床
        const floorGeometry = new THREE.PlaneGeometry(50, 50);
        const floorMaterial = new THREE.MeshPhongMaterial({ 
            color: 0xffffff,
            specular: 0x333333
        });
        const floor = new THREE.Mesh(floorGeometry, floorMaterial);
        floor.rotation.x = -Math.PI / 2;
        floor.position.y = -0.5;
        scene.add(floor);

        // 移動制御
        let moveForward = false;
        let moveBackward = false;
        let moveLeft = false;
        let moveRight = false;
        let canJump = false;
        let velocity = new THREE.Vector3();
        const direction = new THREE.Vector3();

        const speed = 0.01;
        const jumpSpeed = 0.25;
        const gravity = 0.01;

        // マウス制御
        document.body.requestPointerLock = document.body.requestPointerLock || document.body.mozRequestPointerLock;
        document.addEventListener('click', () => {
            document.body.requestPointerLock();
        });

        document.addEventListener('mousemove', (event) => {
            if (document.pointerLockElement === document.body || 
                document.mozPointerLockElement === document.body) {
                const sensitivity = 0.002;
                camera.rotation.y -= event.movementX * sensitivity;
                camera.rotation.y = Math.max(-Math.PI/2, Math.min(Math.PI/2, camera.rotation.y));
                camera.rotation.x -= event.movementY * sensitivity;
                camera.rotation.x = Math.max(-Math.PI/2, Math.min(Math.PI/2, camera.rotation.x));
            }
        });

        // キー入力
        document.addEventListener('keydown', (event) => {
            switch (event.code) {
                case 'KeyW': moveForward = true; break;
                case 'KeyS': moveBackward = true; break;
                case 'KeyA': moveRight = true; break;
                case 'KeyD': moveLeft = true; break;
                case 'Space': if (canJump) { velocity.y = jumpSpeed; canJump = false; } break;
            }
        });

        document.addEventListener('keyup', (event) => {
            switch (event.code) {
                case 'KeyW': moveForward = false; break;
                case 'KeyS': moveBackward = false; break;
                case 'KeyA': moveRight = false; break;
                case 'KeyD': moveLeft = false; break;
            }
        });

        // ウィンドウリサイズ対応
        window.addEventListener('resize', () => {
            camera.aspect = window.innerWidth / window.innerHeight;
            camera.updateProjectionMatrix();
            renderer.setSize(window.innerWidth, window.innerHeight);
        });

        // アニメーションループ
        function animate() {
            requestAnimationFrame(animate);

            // 移動計算
            velocity.x -= velocity.x * 0.1;
            velocity.z -= velocity.z * 0.1;
            velocity.y -= gravity;

            direction.z = Number(moveForward) - Number(moveBackward);
            direction.x = Number(moveRight) - Number(moveLeft);
            direction.normalize();

            if (moveForward || moveBackward) velocity.z -= direction.z * speed;
            if (moveLeft || moveRight) velocity.x -= direction.x * speed;

            camera.translateX(velocity.x);
            camera.translateZ(velocity.z);
            camera.position.y += velocity.y;

            // 地面との衝突判定
            if (camera.position.y < 1) {
                velocity.y = 0;
                camera.position.y = 1;
                canJump = true;
            }

            // 立方体の回転アニメーション
            cubes.forEach(cube => {
                cube.rotation.x += 0.001;
                cube.rotation.y += 0.001;
            });

            renderer.render(scene, camera);
        }

        animate();