// 敵クラスの定義
class Yonezu_Kenshi {
    constructor(scene, player, position) {
        this.scene = scene;
        this.player = player; // プレイヤー（カメラ）を参照
        this.hp = 5; // 敵のHP（5発で倒れる）
        this.speed = 0.05; // 移動速度
        this.attackDamage = 2; // プレイヤーに与えるダメージ
        this.attackCooldown = 1; // 攻撃のクールダウン（秒）
        this.lastAttackTime = 0; // 最後に攻撃した時間

        // スプライトの設定
        const textureLoader = new THREE.TextureLoader();
        const spriteTexture = textureLoader.load('./img/Yoezu.png');
        this.spriteMaterial = new THREE.SpriteMaterial({ map: spriteTexture });
        this.sprite = new THREE.Sprite(this.spriteMaterial);
        this.sprite.position.copy(position);
        this.sprite.scale.set(2, 2, 1); // サイズ調整
        this.scene.add(this.sprite);

        // アニメーション設定
        this.frameCount = 2; // フレーム数（スプライトシートのフレーム数）
        this.currentFrame = 0;
        this.frameDuration = 0.05; // 各フレームの表示時間（秒）
        this.lastFrameUpdate = 0;

        // スプライトシートのフレームサイズ（UVマッピング）
        this.spriteMaterial.map.repeat.set(1 / this.frameCount, 1);
        this.spriteMaterial.map.offset.set(0, 0);
    }

    update(delta) {
        // プレイヤーに向かって移動
        const direction = this.player.position.clone().sub(this.sprite.position).normalize();
        this.sprite.position.add(direction.multiplyScalar(this.speed));

        // プレイヤーとの距離を計算
        const distanceToPlayer = this.sprite.position.distanceTo(this.player.position);
        const currentTime = performance.now() / 1000;

        // 攻撃（接触時）
        if (distanceToPlayer < 1.5 && currentTime - this.lastAttackTime > this.attackCooldown) {
            this.attack();
            this.lastAttackTime = currentTime;
        }

        // アニメーション更新
        if (currentTime - this.lastFrameUpdate > this.frameDuration) {
            this.currentFrame = (this.currentFrame + 1) % this.frameCount;
            this.spriteMaterial.map.offset.set(this.currentFrame / this.frameCount, 0);
            this.lastFrameUpdate = currentTime;
        }

        // プレイヤーの方を向く
        this.sprite.lookAt(this.player.position);
    }

    attack() {
        hp -= this.attackDamage;
        hp = Math.max(0, hp);
        updateHpBar();

        // ダメージエフェクトを表示
        showDamageEffect();

        if (hp <= 0) {
            gameOver();
        }
    }

    takeDamage() {
        this.hp -= 1;
        if (this.hp <= 0) {
            this.scene.remove(this.sprite);
            enemiesDefeated++; // 敵を倒した数を増やす

            return true; // 敵が倒されたことを示す
        }
        return false;
    }

    getSprite() {
        return this.sprite;
    }
}