document.getElementById('start-button').addEventListener('click', startGame);

let currentBGM = '';
let bgmPosition = 0;
let bgmElement = document.getElementById('bgm');

function startGame() {
    document.getElementById('title-screen').style.display = 'none';
    document.getElementById('game-screen').style.display = 'block';
    showScene(0);
}

const scenes = [
    {
        background: 'scene1.jpg',
        leftCharacter: 'character1.png',
        rightCharacter: 'character2.png',
        dialogue: 'これは最初のシーンです。',
        bgm: './data/bgm/',
        sfx: 'sfx1.mp3',
        choices: [
            { text: '選択肢1', nextScene: 1 },
            { text: '選択肢2', nextScene: 2 }
        ]
    },
    {
        background: 'scene2.jpg',
        leftCharacter: 'character1.png',
        rightCharacter: 'character3.png',
        dialogue: 'これは2番目のシーンです。',
        bgm: './data/bgm/',
        sfx: 'sfx2.mp3',
        choices: []
    },
    {
        background: 'scene3.jpg',
        leftCharacter: 'character2.png',
        rightCharacter: 'character3.png',
        dialogue: 'これは3番目のシーンです。',
        bgm: './data/bgm/',
        sfx: 'sfx3.mp3',
        choices: []
    }
];

function showScene(index) {
    const scene = scenes[index];
    document.getElementById('background').style.backgroundImage = `url(${scene.background})`;
    document.getElementById('left-character').style.backgroundImage = `url(${scene.leftCharacter})`;
    document.getElementById('right-character').style.backgroundImage = `url(${scene.rightCharacter})`;
    changeBGM(scene.bgm);
    playSFX(scene.sfx);
    typeDialogue(scene.dialogue, () => {
        if (scene.choices.length > 0) {
            showChoices(scene.choices);
        }
    });
}

function changeBGM(bgm) {
    if (bgm === currentBGM) {
        bgmElement.currentTime = bgmPosition;
        bgmElement.play();
    } else {
        fadeOut(bgmElement, () => {
            bgmElement.src = bgm;
            bgmElement.currentTime = 0;
            bgmElement.play();
            fadeIn(bgmElement);
            currentBGM = bgm;
            bgmPosition = 0;
        });
    }
}

function fadeIn(audioElement) {
    let volume = 0;
    audioElement.volume = volume;
    const fadeInInterval = setInterval(() => {
        if (volume < 1) {
            volume += 0.1;
            audioElement.volume = volume;
        } else {
            clearInterval(fadeInInterval);
        }
    }, 100);
}

function fadeOut(audioElement, callback) {
    let volume = audioElement.volume;
    const fadeOutInterval = setInterval(() => {
        if (volume > 0) {
            volume -= 0.1;
            audioElement.volume = volume;
        } else {
            clearInterval(fadeOutInterval);
            callback();
        }
    }, 100);
}

function playSFX(sfx) {
    const sfxElement = new Audio(sfx);
    sfxElement.play();
}

bgmElement.addEventListener('timeupdate', () => {
    bgmPosition = bgmElement.currentTime;
});

function typeDialogue(text, callback) {
    const dialogueText = document.getElementById('dialogue-text');
    dialogueText.textContent = '';
    let i = 0;
    const typingSpeed = 50;
    const interval = setInterval(() => {
        if (i < text.length) {
            dialogueText.textContent += text.charAt(i);
            i++;
        } else {
            clearInterval(interval);
            setTimeout(callback, 1000);
        }
    }, typingSpeed);
}

function showChoices(choices) {
    const choicesContainer = document.getElementById('choices');
    choicesContainer.style.display = 'block';
    choicesContainer.innerHTML = '';
    choices.forEach(choice => {
        const button = document.createElement('button');
        button.className = 'choice-button';
        button.textContent = choice.text;
        button.addEventListener('click', () => {
            choicesContainer.style.display = 'none';
            showScene(choice.nextScene);
        });
        choicesContainer.appendChild(button);
    });
}
