
function setSwitch(switchName, state) {
    if (switches.hasOwnProperty(switchName)) {
        switches[switchName] = state;
    }
}

function changeBGM(bgm) {
    if (!bgmElement) {
        console.error("BGM element not found");
        return;
    }
    if (bgm === currentBGM) {
        bgmElement.currentTime = bgmPosition;
        bgmElement.play().catch(err => console.error("BGM play error:", err));
    } else {
        fadeOut(bgmElement, () => {
            bgmElement.src = bgm;
            bgmElement.currentTime = 0;
            bgmElement.play().catch(err => console.error("BGM play error:", err));
            fadeIn(bgmElement);
            currentBGM = bgm;
            bgmPosition = 0;
        });
    }
}

function fadeIn(audioElement) {
    let volume = 0;
    audioElement.volume = volume;
    const fadeInInterval = setInterval(() => {
        if (volume < 1) {
            volume += 0.1;
            audioElement.volume = volume;
        } else {
            clearInterval(fadeInInterval);
        }
    }, 100);
}

function fadeOut(audioElement, callback) {
    let volume = audioElement.volume;
    const fadeOutInterval = setInterval(() => {
        if (volume > 0) {
            volume -= 0.1;
            audioElement.volume = volume;
        } else {
            clearInterval(fadeOutInterval);
            callback();
        }
    }, 100);
}

function playSFX(sfx) {
    if (sfx) {
        const sfxElement = new Audio(sfx);
        sfxElement.play().catch(err => console.error("SFX play error:", err));
    }
}

bgmElement?.addEventListener('timeupdate', () => {
    bgmPosition = bgmElement.currentTime;
});

function typeDialogue(text, textTickSFX, callback) {
    const dialogueText = document.getElementById('dialogue-text');
    if (!dialogueText) {
        console.error("Dialogue text element not found");
        return;
    }
    dialogueText.textContent = '';
    let i = 0;
    const typingSpeed = 60;
    const interval = setInterval(() => {
        if (i < text.length) {
            dialogueText.textContent += text.charAt(i);
            if (textTickSFX && text.charAt(i).trim() !== '') {
                const tickSFX = new Audio(textTickSFX);
                tickSFX.play().catch(err => console.error("Text tick SFX play error:", err));
            }
            i++;
        } else {
            clearInterval(interval);
            setTimeout(callback, 500);
        }
    }, typingSpeed);
}

function showChoices(choices) {
    const choicesContainer = document.getElementById('choices');
    if (!choicesContainer) {
        console.error("Choices container not found");
        return;
    }
    choicesContainer.style.display = 'block';
    choicesContainer.innerHTML = '';
    choices.forEach(choice => {
        const button = document.createElement('button');
        button.className = 'choice-button';
        button.textContent = choice.text;
        button.addEventListener('click', () => {
            choicesContainer.style.display = 'none';
            showScene(choice.nextScene);
        });
        choicesContainer.appendChild(button);
    });
}