/* ディレクトリパスはHTMLに代入されます。なので、HTMLの場所を基準にファイルを参照するディレクトリパスを書き込んでください。 */
const scenes = [
    {
        id: 0, /* このシーンのid */
        background: './data/img/background/ビルの間.jpg', /* このシーンで表示する背景画像 */
        defaultLeftCharacter: './data/img/character/', /* このシーンで表示する左側の立ち絵 */
        defaultCenterCharacter: './data/img/character/wolf-正面.png', /* このシーンで表示する中央の立ち絵 */
        defaultRightCharacter: './data/img/character/', /* このシーンで表示する右側の立ち絵 */
        dialogue: 'これは最初のシーンです。', /* このシーンで表示するテキスト */
        bgm: './data/bgm/', /* このシーンで使用するBGMファイルのディレクトリパス */
        sfx: './data/se/', /* このシーンで使用する効果音ファイルのディレクトリパス */
        textTickSFX: './data/se/text-se/会話パート0.mp3', /* テキストのアニメーションに合わせて鳴らす効果音 */

        /* 画像を表示する際に付ける視覚効果。各画像に付与したい視覚効果を番号で指定します。 */
        background_Effect: '1', /* 「1」は表示の際にフェードインを付与 */
        LeftCharacter_Effect: '0', /* 「0」は視覚効果なし */
        CenterCharacter_Effect: '2', /* 「2」は表示の際にフェードイン、シーン切り替えの際にフェードアウトをする */
        RightCharacter_Effect: '0', /* 「0」は視覚効果なし */
 
        /* 選択肢（textにボタンに表示するテキスト、nextSceneに移動したいシーンのidを指定する。）
            ボタンの数はchoicesに書いた{ text: 'ボタンに表示するテキスト', nextScene: 次のシーン }の数分表示される。 */
        choices: [
            { text: 'インデックス番号１', nextScene: 1 },
            { text: 'インデックス番号0', nextScene: 0 }
        ],
        /* 条件分岐で「スイッチ管理オブジェクト」に登録したスイッチが「true」になった際、id0に表示するシーン
            スイッチ管理オブジェクトは<!-- セーブ＆ロードロジック -->のコード内にあります。
            条件分岐は、このソースコードページの139行目に書いてあります。 */
        alternateScenes: {
            'あ': {
                background: './data/img/background',
                defaultLeftCharacter: './data/img/character/',
                defaultCenterCharacter: './data/img/character/',
                defaultRightCharacter: './data/img/character/',
                dialogue: 'これはスイッチ「あ」がオンの場合のシーンです。',
                bgm: './data/bgm/',
                sfx: './data/se/',
                textTickSFX: './data/se/text-se/会話パート1.mp3',
                background_Effect: '0',
                LeftCharacter_Effect: '0',
                CenterCharacter_Effect: '0',
                RightCharacter_Effect: '0',
                choices: [
                    { text: 'インデックス番号３', nextScene: 3 },
                    { text: 'インデックス番号０', nextScene: 0 }
                ]
            }
        }
    },
    {
        id: 1,
        background: './data/img/background/裏路地１.jpg',
        defaultLeftCharacter: './data/img/character/wolf-正面.png',
        defaultCenterCharacter: './data/img/character/',
        defaultRightCharacter: './data/img/character/',
        dialogue: 'インデックス番号１のシーンです。',
        bgm: './data/bgm/',
        sfx: './data/se/',
        textTickSFX: './data/se/text-se/会話パート0.mp3',
        background_Effect: '2',
        LeftCharacter_Effect: '2',
        CenterCharacter_Effect: '0',
        RightCharacter_Effect: '0',
        choices: [
            { text: 'インデックス番号１', nextScene: 1 },
            { text: 'インデックス番号２', nextScene: 2 }
        ]
    },
    {
        id: 2,
        background: './data/img/background',
        defaultLeftCharacter: './data/img/character/',
        defaultCenterCharacter: './data/img/character/',
        defaultRightCharacter: './data/img/character/',
        dialogue: 'これはインデックス番号２のシーンです。',
        bgm: './data/bgm/',
        sfx: './data/se/',
        textTickSFX: './data/se/text-se/会話パート0.mp3',
        background_Effect: '2', // Fade-out for background
        LeftCharacter_Effect: '2', // Fade-out for left character
        CenterCharacter_Effect: '0',
        RightCharacter_Effect: '0',
        choices: [
            { text: 'インデックス番号１', nextScene: 1 },
            { text: 'インデックス番号０', nextScene: 0 }
        ]
    },
    {
        id: 3,
        background: './data/img/background',
        defaultLeftCharacter: './data/img/character/',
        defaultCenterCharacter: './data/img/character/',
        defaultRightCharacter: './data/img/character/',
        dialogue: 'ゲームオーバー',
        bgm: './data/bgm/',
        sfx: './data/se/',
        textTickSFX: './data/se/text-se/会話パート1.mp3',
        background_Effect: '0',
        LeftCharacter_Effect: '0',
        CenterCharacter_Effect: '0',
        RightCharacter_Effect: '0',
        choices: [
            { text: 'インデックス番号０に戻る', nextScene: 0 },
        ]
    }
];

/* 視覚効果ロジック */
function applyFadeEffect(element, effect) {
    return new Promise(resolve => {
        if (!element) {
            console.error("Element not found for fade effect");
            resolve();
            return;
        }
        console.log(`Applying effect ${effect} to element`, element.id); // Debug
        if (effect === '1') { // Fade-in
            element.style.opacity = '0';
            element.style.transition = 'opacity 1s ease';
            setTimeout(() => {
                element.style.opacity = '1';
                setTimeout(resolve, 1000);
            }, 10);
        } else if (effect === '2') { // Fade-out
            element.style.opacity = '1';
            element.style.transition = 'opacity 1s ease';
            setTimeout(() => {
                element.style.opacity = '0';
                setTimeout(resolve, 1000);
            }, 10);
        } else { // No effect
            element.style.opacity = '1';
            element.style.transition = 'none';
            resolve();
        }
    });
}

/* 条件分岐処理 */
/* ノベルジェネシスでの条件分岐はシーンを訪れた回数に合わせて分岐
（スイッチ管理オブジェクトに定義したスイッチのtrue or false）を行うことができます。 */
function showScene(index) {
    const scene = scenes.find(s => s.id === index);
    if (!scene) {
        console.error("Scene not found:", index);
        return;
    }
    currentSceneId = scene.id;
    console.log("Showing scene:", scene.id); // Debug

    /* 例：id:1のシーンの訪れた回数をカウント。
        カウントは、スイッチ管理オブジェクトの上にある「変数管理オブジェクト」で定義した変数にカウントを行います。 */
    if (scene.id === 1) {
        gameVariables.scene1VisitedCount++;
    }

    /* もし、id1を訪れた回数が5階以上なら、スイッチ管理オブジェクトに定義したスイッチ「あ」をtrueにして、
        カウント用変数を０にする */
    if (gameVariables.scene1VisitedCount >= 5) {
        setSwitch('あ', true);
        gameVariables.scene1VisitedCount = 0; /* ここでカウント用変数の中身を0にしている。 */
    }

    if (scene.alternateScenes) {
        for (let key in scene.alternateScenes) {
            if (switches[key]) {
                const alternateScene = scene.alternateScenes[key];
                scene.background = alternateScene.background;
                scene.defaultLeftCharacter = alternateScene.defaultLeftCharacter;
                scene.defaultCenterCharacter = alternateScene.defaultCenterCharacter;
                scene.defaultRightCharacter = alternateScene.defaultRightCharacter;
                scene.dialogue = alternateScene.dialogue;
                scene.bgm = alternateScene.bgm;
                scene.sfx = alternateScene.sfx;
                scene.textTickSFX = alternateScene.textTickSFX;
                scene.background_Effect = alternateScene.background_Effect;
                scene.LeftCharacter_Effect = alternateScene.LeftCharacter_Effect;
                scene.CenterCharacter_Effect = alternateScene.CenterCharacter_Effect;
                scene.RightCharacter_Effect = alternateScene.RightCharacter_Effect;
                scene.choices = alternateScene.choices;
                break;
            }
        }
    }

    const backgroundElement = document.getElementById('background');
    const leftCharacterElement = document.getElementById('left-character');
    const centerCharacterElement = document.getElementById('center-character');
    const rightCharacterElement = document.getElementById('right-character');

    if (!backgroundElement || !leftCharacterElement || !centerCharacterElement || !rightCharacterElement) {
        console.error("One or more scene elements not found");
        return;
    }

    // Set images first for fade-in, or after fade-out
    if (scene.background_Effect !== '2') backgroundElement.style.backgroundImage = `url(${scene.background})`;
    if (scene.LeftCharacter_Effect !== '2') leftCharacterElement.style.backgroundImage = `url(${scene.defaultLeftCharacter})`;
    if (scene.CenterCharacter_Effect !== '2') centerCharacterElement.style.backgroundImage = `url(${scene.defaultCenterCharacter})`;
    if (scene.RightCharacter_Effect !== '2') rightCharacterElement.style.backgroundImage = `url(${scene.defaultRightCharacter})`;

    Promise.all([
        applyFadeEffect(backgroundElement, scene.background_Effect),
        applyFadeEffect(leftCharacterElement, scene.LeftCharacter_Effect),
        applyFadeEffect(centerCharacterElement, scene.CenterCharacter_Effect),
        applyFadeEffect(rightCharacterElement, scene.RightCharacter_Effect)
    ]).then(() => {
        // Set images after fade-out
        if (scene.background_Effect === '2') backgroundElement.style.backgroundImage = `url(${scene.background})`;
        backgroundElement.style.backgroundImage = `url(${scene.background})`;
        backgroundElement.style.opacity = '1'; // 追加
        if (scene.LeftCharacter_Effect === '2') leftCharacterElement.style.backgroundImage = `url(${scene.defaultLeftCharacter})`;
        leftCharacterElement.style.backgroundImage = `url(${scene.defaultLeftCharacter})`;
        leftCharacterElement.style.opacity = '1'; // 追加
        if (scene.CenterCharacter_Effect === '2') centerCharacterElement.style.backgroundImage = `url(${scene.defaultCenterCharacter})`;
        centerCharacterElement.style.backgroundImage = `url(${scene.defaultCenterCharacter})`;
        centerCharacterElement.style.opacity = '1'; // 追加
        if (scene.RightCharacter_Effect === '2') rightCharacterElement.style.backgroundImage = `url(${scene.defaultRightCharacter})`;
        rightCharacterElement.style.backgroundImage = `url(${scene.defaultRightCharacter})`;
        rightCharacterElement.style.opacity = '1'; // 追加
        changeBGM(scene.bgm);
        playSFX(scene.sfx);
        typeDialogue(scene.dialogue, scene.textTickSFX, () => {
            if (scene.choices.length > 0) {
                showChoices(scene.choices);
            }
        });
    }).catch(err => console.error("Fade effect error:", err));
}
